﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;

namespace JAMM.Kasse
{
    /// <summary>
    /// Interaktionslogik für BillWindow.xaml
    /// </summary>
    public partial class BillWindow : Window
    {
        //Hardcoded Unternehmensdaten
        private string businessName = "Restaurant WPF";
        private string businessAddressStreet = "Schloßallee 1";
        private string businessAddressCity = "24939 Flensburg";
        private string businessByeMessage = "Vielen Dank für Ihren Besuch!";
        private string businessTaxNumber = "Steuernummer 7834741";        

        public BillWindow(List<Models.OrderItem> ordered)
        {
            InitializeComponent();

            //Werte setzen
            businessNameLabel.Content = businessName;
            businessAddressLabel.Content = businessAddressStreet + "  " + businessAddressCity;
            businessByeMessageLabel.Content = businessByeMessage;
            businessTaxNumberLabel.Content = businessTaxNumber;
            billDateLabel.Content = System.DateTime.Now.ToShortDateString() + " " + System.DateTime.Now.ToShortTimeString();

            //Abrechnungsdaten werden übergeben
            List<Models.OrderItem> billItems = ordered;
            //Binding
            BillView.ItemsSource = billItems;

            //Endsumme und Steuern berechnen
            float gesSumme = 0;
            float steuer19 = 0;
            float steuer7 = 0;
            foreach (Models.OrderItem billItem in billItems)
            {
                gesSumme += billItem.Sum;
                if (billItem.TaxId == 0) steuer19 += billItem.Sum * 0.19f;
                if (billItem.TaxId == 1) steuer7 += billItem.Sum * 0.7f;
            }

            //Labels setzen
            summeLabel.Content = "Endsumme: " + string.Format("{0:c}", gesSumme);
            steuer7Label.Content = "7% MwSt.: " + string.Format("{0:c}", steuer7);
            steuer19Label.Content = "19% MwSt.: " + string.Format("{0:c}", steuer19);

            //Bill zeigen
            Show();
        }
    }
}
