﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace JAMM.Kasse.Models
{
    /// <summary>
    /// Model für bestelltes Produkt mit Anzahl
    /// </summary>
    public class OrderItem
    {
        private Models.Product product;
        private int quantity;
        private float sum;

        //Konstruktor
        public OrderItem(Models.Product product, int quantity, float sum)
        {
            this.product = product;
            this.quantity = quantity;
            this.sum = sum;
        }

        //ab hier Properties

        public int Quantity
        {
            get { return quantity; }
        }

        public int ProductId
        {
            get { return product.Id; }
        }

        public string ProductName
        {
            get { return product.Name + "\n" + string.Format("{0:c}", product.Price); }
        }

        public string ProductNameBill
        {
            get { return product.Name; }
        }

        public float ProductPrice
        {
            get { return product.Price; }
        }
 
        public float Sum
        {
            get { return sum; }
        }

        public string SumBill
        {
            get { return string.Format("{0:c}", Sum); }
        }

        public int TaxId
        {
            get { return product.TaxId; }
        }
    }
}
