﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Globalization;

namespace JAMM.Kasse.Models
{
    /// <summary>
    /// Model für ein Produkt
    /// </summary>
    public class Product
    {
        private int id;
        private int number;
        private string name;
        private float price;
        private int groupId;
        private int taxId;

        //alter Konstruktor (bleibt wegen "Abwärtskompatibilität" erhalten)
        public Product(int id, int number, string name, float price)
        {
            this.id = id;
            this.number = number;
            this.name = name;
            this.price = price;
            this.groupId = 0;
            this.taxId = 0;
        }

        //neuer Konstruktur
        public Product(int id, int number, string name, float price, int groupId, int taxId)
        {
            this.id = id;
            this.number = number;
            this.name = name;
            this.price = price;
            this.groupId = groupId;
            this.taxId = taxId;
        }

        //ab hier Properties

        public int Id
        {
            get { return id; }
        }

        public int Number
        {
            get { return number; }
        }

        public string Name
        {
            get { return name; }
        }

        public float Price
        {
            get { return price; }
        }

        public string PriceToString
        {
            get { return price.ToString(CultureInfo.CurrentCulture); }
        }

        public string ButtonLabel
        {
            get { return Name + "\n" + Price + " €"; }
        }

        public int GroupId
        {
            get { return groupId; }
        }

        public int TaxId
        {
            get { return taxId; }
        }

        public string GroupToString
        {
            get { return new DB().getGroup(this.GroupId).Name;  }
        }

        public string TaxToString
        {
            get { return new DB().getTax(this.TaxId).TaxToString; }
        }

    }
}
