﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace JAMM.Kasse.Models
{
    /// <summary>
    /// Model für Benutzer
    /// </summary>
    public class User
    {
        #region Fields

        private int id;
        private int role;
        private string userName;
        private string password;

        #endregion // Fields

        #region Constructors

        public User()
        {
        }

        public User(int id, int role, string userName, string password)
        {
            this.id = id;
            this.role = role;
            this.userName = userName;
            this.password = password;
        }

        #endregion // Constructors

        //ab hier Properties
        #region Properties

        public int UserId
        {
            get { return id; }
            set
            {
                if (value != id)
                {
                    id = value;
                }
            }
        }

        public int Role
        {
            get { return role; }
            set
            {
                if (value != role)
                {
                    role = value;
                }
            }
        }

        public string UserName
        {
            get { return userName; }
            set
            {
                if (value != userName)
                {
                    userName = value;
                }
            }
        }

        public string Password
        {
            get { return password; }
            set
            {
                if (value != password)
                {
                    password = value;
                }
            }
        }

        #endregion // Properties

        #region Methods

        public string RoleToString
        {
            get
            {
                if (this.Role == 2)
                {
                    return "Admin";
                }
                else
                {
                    return "Kasse";
                }
            }
        }

        #endregion
    }
}
