﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace JAMM.Kasse.Pages
{
    /// <summary>
    /// Interaction logic for Bill.xaml
    /// </summary>
    public partial class Bill : Page
    {
        public Bill(Models.Table table)
        {
            InitializeComponent();
            //Überschrift setzen
            billHeader.Content = table.Name + " " + table.Number;

            GetDb();
        }

        private void GetDb()
        {
            // Liste mit OrderItems des Tisches
            List<Models.OrderItem> orders = new DB().getOrders(Pages.Checkout.getInstance().getSelectedTable.Id);
            List<Models.OrderItem> ordered = new DB().getOrdered(Pages.Checkout.getInstance().getSelectedTable.Id);

            //Bindings der Listen
            UnorderedView.ItemsSource = orders;
            OrderedView.ItemsSource = ordered;
        }

        //Inkrementieren der Anzahl eines Produkts
        private void Increase(object sender, RoutedEventArgs e)
        {
            int productId = ((Models.OrderItem)((Button)sender).DataContext).ProductId;
            int tableId = Pages.Checkout.getInstance().getSelectedTable.Id;
            int userId = Pages.Checkout.getInstance().getCurrentUser.UserId;

            new DB().addOrder(productId, tableId, userId);

            GetDb();
        }

        //Dekrementieren der Anzahl eines Produkts
        private void Decrease(object sender, RoutedEventArgs e)
        {
            int productId = ((Models.OrderItem)((Button)sender).DataContext).ProductId;
            int tableId = Pages.Checkout.getInstance().getSelectedTable.Id;
            int userId = Pages.Checkout.getInstance().getCurrentUser.UserId;

            new DB().removeOrder(productId, tableId, userId);

            GetDb();
        }

        //Buchen von ausgewählten Produkten
        private void book(object sender, RoutedEventArgs e)
        {
            new DB().order(Pages.Checkout.getInstance().getSelectedTable.Id);

            GetDb();
        }

        //Stornieren eines Tisches
        private void cancel(object sender, RoutedEventArgs e)
        {
            int tableId = Pages.Checkout.getInstance().getSelectedTable.Id;

            new DB().removeOrdered(tableId);

            GetDb();
        }

        //Abrechnen eines Tisches
        private void pay(object sender, RoutedEventArgs e)
        {
            List<Models.OrderItem> billItems = new DB().pay(Pages.Checkout.getInstance().getSelectedTable.Id);
            new BillWindow(billItems);

            GetDb();
        }
    }
}
