﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace JAMM.Kasse.Pages
{
    /// <summary>
    /// Interaction logic for Checkout.xaml
    /// </summary>
    public partial class Checkout : Page
    {
        //static fields for the user-selections
        public static Models.Table selectedTable;
        public static Models.Group selectedGroup;
        public static Models.User currentUser;
        //static field for the instance
        private static Pages.Checkout instance;

        //Instanz des Fensters abfragen
        public static Pages.Checkout getInstance()
        {
            return instance;
        }

        //Konstruktor
        public Checkout(Models.User user)
        {
            InitializeComponent();
            instance = this;
            System.Diagnostics.Debug.WriteLine(selectedGroup);
            currentUser = user;
        }

        //Logout-Funktion
        public void logout()
        {
            this.NavigationService.Navigate(new Pages.Login());
        }

        //Ansicht zu Tischen wechseln
        public void switchViewToTables()
        {
            leftFrame.Navigate(new Pages.Tables());
            rightFrame.Navigate(new Pages.OpenTables());
        }

        //Ansicht zu Gruppen wechseln
        public void switchViewToGroups()
        {
            leftFrame.Navigate(new Pages.Groups());
            rightFrame.Navigate(new Pages.Bill(selectedTable));
        }

        //Ansicht zu Produkten wechseln
        public void switchViewToProducts()
        {
            leftFrame.Navigate(new Pages.Products(selectedGroup));
            rightFrame.Navigate(new Pages.Bill(selectedTable));
        }

        //aktuellen User abfragen
        public Models.User getCurrentUser
        {
            get { return currentUser; }
        }

        //ausgewählten Tisch abfragen
        public Models.Table getSelectedTable
        {
            get { return selectedTable; }
        }

        //ausgewählte Gruppe abfragen
        public Models.Group getSelectedGroup
        {
            get { return selectedGroup; }
        }
    }
}
