﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace JAMM.Kasse.Pages
{
    /// <summary>
    /// Interaktionslogik für Dashboard.xaml
    /// </summary>
    public partial class Dashboard : Page
    {
        #region Fields

        private static Models.User currentUser;
        private static Pages.Dashboard instance;

        #endregion // Fields

        #region Constructors
        //Konstruktor
        public Dashboard(Models.User user)
        {
            InitializeComponent();
            ShowReports();
            instance = this;
            currentUser = user;
        }

        public static Pages.Dashboard getInstance
        {
            get { return instance; }
        }

        public Models.User getCurrentUser
        {
            get { return currentUser; }
        }

        #endregion // Constructors

        #region Reports

        private void Reports_Click(object sender, RoutedEventArgs e)
        {
            ShowReports();
        }

        private void Today_Click(object sender, RoutedEventArgs e)
        {
            this.FrameContent.Navigate(new Pages.ReportsToday());
        }

        private void Yesterday_Click(object sender, RoutedEventArgs e)
        {
            this.FrameContent.Navigate(new Pages.ReportsYesterday());
        }

        private void ThisWeek_Click(object sender, RoutedEventArgs e)
        {
            this.FrameContent.Navigate(new Pages.ReportThisWeek());
        }

        private void ThisMonth_Click(object sender, RoutedEventArgs e)
        {
            this.FrameContent.Navigate(new Pages.ReportsThisMonth());
        }

        private void ThisYear_Click(object sender, RoutedEventArgs e)
        {
            this.FrameContent.Navigate(new Pages.ReportsThisYear());
        }

        #endregion // Reports

        #region Organisation

        private void Organisation_Click(object sender, RoutedEventArgs e)
        {
            ShowOrganisation();
        }

        private void Tische_Click(object sender, RoutedEventArgs e)
        {
            this.FrameContent.Navigate(new Pages.EditTables());
        }

        private void Gruppen_Click(object sender, RoutedEventArgs e)
        {
            this.FrameContent.Navigate(new Pages.EditGroups());
        }

        private void Products_Click(object sender, RoutedEventArgs e)
        {
            this.FrameContent.Navigate(new Pages.EditProducts());
        }

        private void Mitarbeiter_Click(object sender, RoutedEventArgs e)
        {
            this.FrameContent.Navigate(new Pages.EditUsers());
        }

        #endregion //Organisation

        #region BillAndLogout

        private void CashRegister_Click(object sender, RoutedEventArgs e)
        {
            NavigationService.Navigate(new Checkout(getCurrentUser));
        }

        private void Logout_Click(object sender, RoutedEventArgs e)
        {
            NavigationService.Navigate(new Pages.Login());
        }

        #endregion //BillAndLogout

        #region Helpermethoden

        private void ShowReports()
        {
            this.submenuBerichte.Visibility = Visibility.Visible;
            this.submenuOrganisation.Visibility = Visibility.Hidden;
            this.FrameContent.Navigate(new Pages.ReportsToday());
        }

        private void ShowOrganisation()
        {
            this.submenuBerichte.Visibility = Visibility.Hidden;
            this.submenuOrganisation.Visibility = Visibility.Visible;
            this.FrameContent.Navigate(new Pages.EditGroups());
        }

        #endregion //Helpermethoden
    }
}
