﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace JAMM.Kasse.Pages
{
    /// <summary>
    /// Interaktionslogik für EditGroup.xaml
    /// </summary>
    public partial class EditGroups : Page
    {
        //Konstruktor
        public EditGroups()
        {
            InitializeComponent();
            refresh();
        }

        //Erneuern der Ansicht
        private void refresh()
        {
            GroupView.ItemsSource = new DB().getGroups();
        }

        //Gruppe hinzufügen
        private void addGroup(object sender, RoutedEventArgs e)
        {
            //Überprüfen, ob in beide Felder etwas eingegeben wurde
            if ((groupNumberEdit.Text != "") && (groupNameEdit.Text != ""))
            {
                int number;
                //Überprüfen, ob im Nummernfeld eine Zahl eingegeben wurde
                if (Int32.TryParse(groupNumberEdit.Text, out number) == true)
                {
                    if (new DB().addGroup(new Models.Group(0, number, groupNameEdit.Text)) == true)
                    {
                        groupNameEdit.Text = "";
                        groupNumberEdit.Text = "";
                        refresh();
                    }
                    else
                    {
                        stillProducts.Visibility = Visibility.Visible;
                    }
                }
                else
                {
                    wrongGroupNo.Visibility = Visibility.Visible;
                    groupNumberEdit.BorderBrush = Brushes.Red;
                    
                }
            }
            else
            {
                wrongFields.Visibility = Visibility.Visible;
                groupNumberEdit.BorderBrush = Brushes.Red;
                groupNameEdit.BorderBrush = Brushes.Red;
            }
        }

        //Gruppe löschen
        private void deleteGroup(object sender, RoutedEventArgs e)
        {
            new DB().removeGroup(((Models.Group)((Button)sender).DataContext));
            refresh();
        }

        private void TextBoxGotKeyboardFocus(object sender, KeyboardFocusChangedEventArgs e)
        {
            TextBox source = e.Source as TextBox;

            if (source != null)
            {
                // Change the TextBox border and error label when it obtains focus.
                source.BorderBrush = Brushes.LightBlue;
                wrongGroupNo.Visibility = Visibility.Hidden;
            }

        
        }

        private void TextBoxGotKeyboardFocus1(object sender, KeyboardFocusChangedEventArgs e)
        {
            TextBox source = e.Source as TextBox;

            if (source != null)
            {
                // Change the TextBox border and error label when it obtains focus.
                source.BorderBrush = Brushes.LightBlue;
                wrongFields.Visibility = Visibility.Hidden;
            }

        }
    }
}
