﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace JAMM.Kasse.Pages
{
    /// <summary>
    /// Interaktionslogik für EditProducts.xaml
    /// </summary>
    public partial class EditProducts : Page
    {
        private List<Models.Group> groupList;
        private List<Models.Tax> taxList;

       //Konstruktor
       public EditProducts()
        {
            InitializeComponent();           
            DataContext = this;
            groupList = new DB().getGroups();
            taxList = new DB().getTaxes();
            refresh();
        }

       //Properties
        public List<Models.Group> GroupList
        {
            get { return groupList; }
        }

        public List<Models.Tax> TaxList
        {
            get { return taxList; }
        }

        //Erneuern der Ansicht
        private void refresh()
        {
            ProductView.ItemsSource = new DB().getAllProducts();
        }

        //Produkt hinzufügen
        private void addProduct(object sender, RoutedEventArgs e)
        {
            //Überprüfen, ob in alle Felder etwas eingegeben wurde
            if ((productNameEdit.Text != "") && (productNumberEdit.Text != "") && (productPriceEdit.Text != ""))
            {
                int groupId = groupList[groupSelect.SelectedIndex].Id; //aus DropDown-Liste holen
                int taxId = taxList[taxSelect.SelectedIndex].Id; //aus DropDown-Liste holen
                int number;
                float price;
                //Überprüfen, ob im Nummernfeld eine Zahl eingegeben wurde
                if ((Int32.TryParse(productNumberEdit.Text, out number) == true) && (Single.TryParse(productPriceEdit.Text, out price) == true))
                {
                    new DB().addProduct(new Models.Product(0, number, productNameEdit.Text, price, groupId, taxId));
                    productNameEdit.Text = "";
                    productNumberEdit.Text = "";
                    productPriceEdit.Text = "";
                    refresh();
                }
                else
                {
                    wrongProductNo.Visibility = Visibility.Visible;
                    productNumberEdit.BorderBrush = Brushes.Red;
                    productPriceEdit.BorderBrush = Brushes.Red;
                }
            }
            else
            {
                wrongProductFields.Visibility = Visibility.Visible;
                productNumberEdit.BorderBrush = Brushes.Red;
                productNameEdit.BorderBrush = Brushes.Red;
                productPriceEdit.BorderBrush = Brushes.Red;
            }
        }

        //Entfernen eines Produkts
        private void deleteProduct(object sender, RoutedEventArgs e)
        {
            new DB().removeProduct(((Models.Product)((Button)sender).DataContext));
            refresh();
        }


        private void TextBoxGotKeyboardFocus(object sender, KeyboardFocusChangedEventArgs e)
        {
            TextBox source = e.Source as TextBox;

            // Change the TextBox borders and error labels when they obtain focus.
            if (source != null)
            {

                wrongProductNo.Visibility = Visibility.Hidden;
                wrongProductFields.Visibility = Visibility.Hidden;
                productNumberEdit.BorderBrush = Brushes.LightBlue;
                productNameEdit.BorderBrush = Brushes.LightBlue;
                productPriceEdit.BorderBrush = Brushes.LightBlue;
            }
        }

        private void TextBoxGotKeyboardFocus1(object sender, KeyboardFocusChangedEventArgs e)
        {
            TextBox source = e.Source as TextBox;

            // Change the TextBox borders and error labels when they obtain focus.
            if (source != null)
            {
                wrongProductNo.Visibility = Visibility.Hidden;
                wrongProductFields.Visibility = Visibility.Hidden;
                productNumberEdit.BorderBrush = Brushes.LightBlue;
                productNameEdit.BorderBrush = Brushes.LightBlue;
                productPriceEdit.BorderBrush = Brushes.LightBlue;
            }
        }

        private void TextBoxGotKeyboardFocus2(object sender, KeyboardFocusChangedEventArgs e)
        {
            TextBox source = e.Source as TextBox;

            // Change the TextBox borders and error labels when they obtain focus.
            if (source != null)
            {
                wrongProductNo.Visibility = Visibility.Hidden;
                wrongProductFields.Visibility = Visibility.Hidden;
                productNumberEdit.BorderBrush = Brushes.LightBlue;
                productNameEdit.BorderBrush = Brushes.LightBlue;
                productPriceEdit.BorderBrush = Brushes.LightBlue;
            }
        }
    }
}
