﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace JAMM.Kasse.Pages
{
    /// <summary>
    /// Interaktionslogik für EditPages.xaml
    /// </summary>
    public partial class EditTables : Page
    {
        //Konstruktor
        public EditTables()
        {
            InitializeComponent();
            refresh();            
        }

        //Erneuern der Ansicht
        private void refresh()
        {
            TableView.ItemsSource = new DB().getTables();
        }

        //Tisch hinzufügen
        private void addTable(object sender, RoutedEventArgs e)
        {
            //Überprüfen, ob in alle Felder etwas eingegeben wurde
            if ((tableNameEdit.Text != "") && (tableDescriptionEdit.Text != "") && (tableNameEdit.Text != ""))
            {
                int number;
                //Überprüfen, ob im Nummernfeld eine Zahl eingegeben wurde
                if (Int32.TryParse(tableNumberEdit.Text, out number) == true)
                {
                    new DB().addTable(new Models.Table(0, number, tableNameEdit.Text, tableDescriptionEdit.Text));
                    tableNameEdit.Text = "";
                    tableNumberEdit.Text = "";
                    tableDescriptionEdit.Text = "";
                    refresh();
                }
                else
                {
                    wrongTableNo.Visibility = Visibility.Visible;
                    tableNumberEdit.BorderBrush = Brushes.Red;
                }
            }
            else
            {
                wrongTableFields.Visibility = Visibility.Visible;
                tableNumberEdit.BorderBrush = Brushes.Red;
                tableNameEdit.BorderBrush = Brushes.Red;
                tableDescriptionEdit.BorderBrush = Brushes.Red;
            }
        }

        //Entfernen des Tisches
        private void deleteTable(object sender, RoutedEventArgs e)
        {
            new DB().removeTable(((Models.Table)((Button)sender).DataContext));
            refresh();
        }

        private void TextBoxGotKeyboardFocus(object sender, KeyboardFocusChangedEventArgs e)
        {
                // Change the TextBox borders and error labels when they obtain focus.
                wrongTableNo.Visibility = Visibility.Hidden;
                wrongTableFields.Visibility = Visibility.Hidden;
                tableNumberEdit.BorderBrush = Brushes.LightBlue;
            
        }

        private void TextBoxGotKeyboardFocus1(object sender, KeyboardFocusChangedEventArgs e)
        {
            TextBox source = e.Source as TextBox;

            // Change the TextBox borders and error labels when they obtain focus.
            if (source != null)
            {
                wrongTableFields.Visibility = Visibility.Hidden;
                tableDescriptionEdit.BorderBrush = Brushes.LightBlue;
                tableNameEdit.BorderBrush = Brushes.LightBlue;
                tableNumberEdit.BorderBrush = Brushes.LightBlue;
            }
        }

        private void TextBoxGotKeyboardFocus2(object sender, KeyboardFocusChangedEventArgs e)
        {
            TextBox source = e.Source as TextBox;

            // Change the TextBox borders and error labels when they obtain focus.
            if (source != null)
            {
                wrongTableFields.Visibility = Visibility.Hidden;
                tableDescriptionEdit.BorderBrush = Brushes.LightBlue;
                tableNameEdit.BorderBrush = Brushes.LightBlue;
                tableNumberEdit.BorderBrush = Brushes.LightBlue;
            }
        }

    }
}
