﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace JAMM.Kasse.Pages
{
    /// <summary>
    /// Interaktionslogik für Staff.xaml
    /// </summary>
    public partial class EditUsers : Page
    {
        //Konstruktor
        public EditUsers()
        {
            InitializeComponent();
            refresh();
            InizialUserRoleBox();
        }

        //Erneuern der Ansicht
        private void refresh()
        {
            UserView.ItemsSource = new DB().getUsers();
        }

        //Entfernen eines Benutzers
        private void deleteUser(object sender, RoutedEventArgs e)
        {
            new DB().removeUser(((Models.User)((Button)sender).DataContext));
            refresh();
        }

        //Hinzufügen eines Benutzers
        private void addUser(object sender, RoutedEventArgs e)
        {
            //Überprüfen, ob in alle Felder etwas eingegeben wurde
            if ((userNameEdit.Text != "") && (userPasswordOneEdit.Password != "") && (userPasswordTwoEdit.Password != ""))
            {
                //Überprüfen, ob Passwörter identisch
                if (userPasswordOneEdit.Password.Equals(userPasswordTwoEdit.Password))
                {
                    if (new DB().addUser(new Models.User(0, userRoleBox.SelectedItem.Equals("Admin")?2:1, userNameEdit.Text, userPasswordOneEdit.Password)) == true)
                    {
                        userNameEdit.Text = "";
                        userPasswordOneEdit.Password = "";
                        userPasswordTwoEdit.Password = "";
                        refresh();
                    }
                    else
                    {
                        wrongUserName.Visibility = Visibility.Visible;
                        userNameEdit.BorderBrush = Brushes.Red;
                        
                    }
                }
                else
                {
                    wrongUserPW.Visibility = Visibility.Visible;
                    userPasswordOneEdit.BorderBrush = Brushes.Red;
                    userPasswordTwoEdit.BorderBrush = Brushes.Red;
                }
            }
            else
            {
                //HIER FEHLERMELDUNG, DASS ALLE FELDER AUSZUFÜLLEN SIND
                wrongUserFields.Visibility = Visibility.Visible;
                userNameEdit.BorderBrush = Brushes.Red;
                userPasswordOneEdit.BorderBrush = Brushes.Red;
                userPasswordTwoEdit.BorderBrush = Brushes.Red;
            }
        }

        //Rollen-Box initialisieren
        private void InizialUserRoleBox()
        {
            this.userRoleBox.Items.Add("Kasse");
            this.userRoleBox.Items.Add("Admin");
            userRoleBox.SelectedItem = "Kasse";
        }

        private void TextBoxGotKeyboardFocus(object sender, KeyboardFocusChangedEventArgs e)
        {
            TextBox source = e.Source as TextBox;

            // Change the TextBox borders and error labels when they obtain focus.
            if (source != null)
            {

                wrongUserName.Visibility = Visibility.Hidden;
                wrongUserPW.Visibility = Visibility.Hidden;
                wrongUserFields.Visibility = Visibility.Hidden;
                userNameEdit.BorderBrush = Brushes.LightBlue;
                userPasswordOneEdit.BorderBrush = Brushes.LightBlue;
                userPasswordTwoEdit.BorderBrush = Brushes.LightBlue;
            }
        }

        private void PasswordBoxGotKeyboardFocus(object sender, KeyboardFocusChangedEventArgs e)
        {
            PasswordBox source = e.Source as PasswordBox;

            // Change the TextBox borders and error labels when they obtain focus.
            if (source != null)
            {

                wrongUserName.Visibility = Visibility.Hidden;
                wrongUserPW.Visibility = Visibility.Hidden;
                wrongUserFields.Visibility = Visibility.Hidden;
                userNameEdit.BorderBrush = Brushes.LightBlue;
                userPasswordOneEdit.BorderBrush = Brushes.LightBlue;
                userPasswordTwoEdit.BorderBrush = Brushes.LightBlue;
            }
        }

        private void PasswordBoxGotKeyboardFocus1(object sender, KeyboardFocusChangedEventArgs e)
        {
            PasswordBox source = e.Source as PasswordBox;

            // Change the TextBox borders and error labels when they obtain focus.
            if (source != null)
            {

                wrongUserName.Visibility = Visibility.Hidden;
                wrongUserPW.Visibility = Visibility.Hidden;
                wrongUserFields.Visibility = Visibility.Hidden;
                userNameEdit.BorderBrush = Brushes.LightBlue;
                userPasswordOneEdit.BorderBrush = Brushes.LightBlue;
                userPasswordTwoEdit.BorderBrush = Brushes.LightBlue;
            }
        }

        private void ComboBoxGotKeyboardFocus(object sender, KeyboardFocusChangedEventArgs e)
        {
            ComboBox source = e.Source as ComboBox;
            
            // Change the TextBox borders and error labels when they obtain focus.
            if (source != null)
            {

                wrongUserName.Visibility = Visibility.Hidden;
                wrongUserPW.Visibility = Visibility.Hidden;
                wrongUserFields.Visibility = Visibility.Hidden;
                userNameEdit.BorderBrush = Brushes.LightBlue;
                userPasswordOneEdit.BorderBrush = Brushes.LightBlue;
                userPasswordTwoEdit.BorderBrush = Brushes.LightBlue;
            }
        }
    }
}