﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Collections;

namespace JAMM.Kasse.Pages
{
    /// <summary>
    /// Interaktionslogik für Groups.xaml
    /// </summary>
    public partial class Groups : Page
    {
        //Konstruktor
        public Groups()
        {
            InitializeComponent();
            //Databinding der Buttons an DB.getGroups()
            GroupView.ItemsSource = new DB().getGroups();          
        }

        //Gruppe auswählen
        private void selectGroup(object sender, RoutedEventArgs e)
        {
            //gewählte Gruppe speichern
            Pages.Checkout.selectedGroup = (Models.Group)((Button)sender).DataContext;
            //zur Produktansicht wechseln
            Pages.Checkout.getInstance().switchViewToProducts();
        }

        //Zurück zu Tischen
        private void goBack(object sender, RoutedEventArgs e)
        {
            Pages.Checkout.getInstance().switchViewToTables();
        }

        //Logout-Funktion
        private void logout(object sender, RoutedEventArgs e)
        {
            //ruft logout in Checkout auf
            Pages.Checkout.getInstance().logout();
        }

        //Such-Funktion
        private void Search(object sender, RoutedEventArgs e)
        {
            GroupView.ItemsSource = new DB().getGroups(searchBox.Text);
        }
    }
}
