﻿using System;
using System.Collections.Generic;
using System.Data.SQLite;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace JAMM.Kasse.Pages
{
    /// <summary>
    /// Interaction logic for Login.xaml
    /// </summary>
    public partial class Login : System.Windows.Controls.Page
    {
        #region Fields

        List<Models.User> userList;

        #endregion // Fields

        #region Constructors

        public Login()
        {
            InitializeComponent();

            userList = new DB().getUsers();

            DataContext = this;
        }
        
        #endregion // Constructors

        #region Properties

        public List<Models.User> UserList
        {
            get { return userList; }
        }

        #endregion // Properties

        #region Methods

        //Login
        private void loginButton_Click(object sender, RoutedEventArgs e)
        {
            var i = userSelect.SelectedIndex;

            // ComboBox.SelectedIndex returns -1 for empty selection
            if (i != -1)
            {
                //Passwort korrekt?
                if (UserList[i].Password == passwordBox.Password)
                {
                    //anhand von Rolle zu Dashboard oder Kasse verweisen
                    switch(UserList[i].Role)
                    {
                        case 1:
                            NavigationService.Navigate(new Checkout(UserList[i]));
                            break;
                        case 2:
                            NavigationService.Navigate(new Dashboard(UserList[i]));
                            break;
                    }
                }
                else
                {
                    //Passwort falsch
                    System.Diagnostics.Debug.WriteLine("Wrong password!");
                    wrongPW.Visibility = Visibility.Visible;
                    passwordBox.BorderBrush = Brushes.Red;
                }
            }
        }

        //Passwortfeld rücksetzen
        private void clearButton_Click(object sender, RoutedEventArgs e)
        {
            passwordBox.Clear();
            //login bypass
            //NavigationService.Navigate(new Dashboard(UserList[0]));
        }

        //Einloggen per Enter-Taste
        private void OnKeyDownHandler(object sender, KeyEventArgs e)
        {
            if (e.Key == Key.Return)
            {
                loginButton_Click(sender, e);
            }
        }

        #endregion // Methods
    }
}
