﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Collections;

namespace JAMM.Kasse.Pages
{
    /// <summary>
    /// Interaktionslogik für Tables.xaml
    /// </summary>
    public partial class Products : Page
    {
        private int groupId;

        //Konstruktor
        public Products(Models.Group group)
        {
            InitializeComponent();
            //Header setzen
            productHeader.Content = group.Name;
            //Databinding der Buttons an DB.getProducts()
            ProductView.ItemsSource = new DB().getProducts(group.Id);
            groupId = group.Id;
        }

        //Produkt zu Tisch hinzufügen
        private void addProduct(object sender, RoutedEventArgs e)
        {
            //Parameter sammeln
            int productId = ((Models.Product)((Button)sender).DataContext).Id;
            int tableId = Pages.Checkout.getInstance().getSelectedTable.Id;
            //in DB einfügen
            new DB().addOrder(productId, tableId, Pages.Checkout.getInstance().getCurrentUser.UserId);

            //switchView aufrufen, um Bill zu aktualisieren
            Pages.Checkout.getInstance().switchViewToProducts();
        }

        //zurück zu Gruppen
        private void goBack(object sender, RoutedEventArgs e)
        {
            Pages.Checkout.getInstance().switchViewToGroups();
        }

        //Logout-Funktion
        private void logout(object sender, RoutedEventArgs e)
        {
            //ruft logout in Checkout auf
            Pages.Checkout.getInstance().logout();
        }

        //Such-Funktion
        private void Search(object sender, RoutedEventArgs e)
        {
            ProductView.ItemsSource = new DB().getProducts(groupId, searchBox.Text);
        }
    }
}
