﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Collections;

namespace JAMM.Kasse.Pages
{
    /// <summary>
    /// Interaktionslogik für Tables.xaml
    /// </summary>
    public partial class Tables : Page
    {
        public Tables()
        {
            InitializeComponent();
            //Databinding der Buttons an DB.getTables()
            TableView.ItemsSource = new DB().getTables();

            if (Pages.Checkout.currentUser.Role == 2)
                backButton.Visibility = System.Windows.Visibility.Visible;
            else
                backButton.Visibility = System.Windows.Visibility.Hidden;
        }

        private void selectTable(object sender, RoutedEventArgs e)
        {
            //gewählten Tisch speichern
            Pages.Checkout.selectedTable = (Models.Table)((Button)sender).DataContext;
            //zur Gruppenansicht wechseln
            Pages.Checkout.getInstance().switchViewToGroups();
        }

        private void logout(object sender, RoutedEventArgs e)
        {
            //ruft logout in Checkout auf
            Pages.Checkout.getInstance().logout();
        }

        private void back(object sender, RoutedEventArgs e)
        {
            Pages.Checkout.getInstance().NavigationService.Navigate(new Pages.Dashboard(Pages.Checkout.currentUser));
        }

        private void Search(object sender, RoutedEventArgs e)
        {
            TableView.ItemsSource = new DB().getTables(searchBox.Text);
        }
    }
}
